import pyidaungsu as pds
import string
from flask import Flask, jsonify, render_template, request, session, redirect, url_for, flash, send_file
from flask_login import login_manager, login_user, logout_user
from importlib_metadata import method_cache
from passlib.hash import pbkdf2_sha256  # for password encrytipn
from datetime import datetime, timedelta
# creating variable to store the
# number of words

app = Flask(__name__)
app.secret_key = "testserver"
login_manager.session_protection = "strong"
app.config['SECRET_TYPE'] = 'secret'
app.config['SESSION_TYPE'] = 'filesystem'


p = pds.tokenize('မင်းဒီမှာဘာလုပ်နေတာလဲ?')


@app.route('/')
def index():
    return render_template('index.html')


@app.route('/back/word-count', methods=['POST'])
def wordCount():
    if request.method == "POST":
        number_of_words = 0
        words = request.form['words']
        if words != "":
            isUnicode = pds.detect(words)
            if isUnicode == 'zg':
                words = pds.cvt2uni(words)
            wordList = pds.tokenize(words)
            for myWord in wordList:
                print(myWord)
                number_of_words += 1
            print(number_of_words)
    return jsonify({'wordCount': number_of_words})
# print(p)

# Opening our text file in read only
# mode using the open() function
# with open(r'C:\Users\iconi\Desktop\s.txt', 'r', encoding='utf8') as file:

#     # Reading the content of the file
#     # using the read() function and storing
#     # them in a new variable
#     data = file.read()

#     # Splitting the data into separate lines
#     # using the split() function
#     lines = data.split()
#     print(lines)

#     # Iterating over every word in
#     # lines
#     for word in lines:

#         # checking if the word is numeric or not
#         if not word.isnumeric():

#             # Adding the length of the
#             # lines in our number_of_words
#             # variable
#             number_of_words += 1

# # Printing total number of words
# print(number_of_words)


if __name__ == '__main__':
    app.run(host='0.0.0.0', port=4040, debug=True)
else:
    from werkzeug.debug import DebuggedApplication
    app.wsgi_app = DebuggedApplication(app.wsgi_app, True)
    app.debug = True
